# G18_v2 — Re-center Mini-Pair (common window + heavy averaging)

Deterministic present‑act engine (stdlib only) that tests **form invariance** and **amplitude consistency** under re‑centering using a **1/r per‑shell DDA**.
No randomness anywhere in control or readouts.

## Quick start

```bash
# (Python 3.9+; no external packages required)
./scripts/run.sh
```

This will:
1. Create a UTC‑stamped workspace: `G18_recentering_v2/<UTC>/`
2. Copy the manifest into `config/`
3. Run the engine and write metrics/audit/run_info
4. Print the one‑line **result**

## Files

- `engine_g18_recentering_v2.py` — exact engine used.
- `config/manifest_g18_v2.json` — exact manifest used for the last passing run (see below).
- `runs/last_pass/` — snapshot of artifacts from the last PASS.
- `scripts/run.sh` — reproducible entrypoint.

## What the engine does

- **Shell census**: count cells by integer radius r around each center.
- **Control (1/r DDA)**: for each r≥1, an integer accumulator adds `rate_num` every tick; when `A[r] ≥ r`, fire once and subtract `r`. Repeat for `H` ticks. (No RNG.)
- **Common interior window**: both centers are evaluated on the **same** radial window:  
  `r_max_glob = min(edge_radius(A), edge_radius(B)) − outer_margin`.  
  This makes amplitude and CV comparable shell‑for‑shell.
- **Readouts**:
  - **Slope**: fit `log(rate_per_cell)` vs `log(Reff/r)` using **log‑spaced bins**, fitting the **mid‑60%**.
  - **Plateau**: compute per‑annulus totals on **equal‑Δr full bins**; report **CV** and **mean amplitude** over the **outer 75%** of those bins.
- **Acceptance** (per manifest):
  - Per‑center: |slope−1|≤0.15, R²≥0.90, CV≤0.10
  - Invariance: Δslope≤0.10, ΔCV≤0.02
  - Amplitude: |amp_ratio−1|≤0.03

## Last PASS (snapshot included)

**Result line:**  
`G18_v2 PASS=True slopeA=1.0020 slopeB=1.0020 Δslope=0.0000 cvA=0.0015 cvB=0.0015 Δcv=0.0000 amp_ratio=1.000 r_max_glob=136`

**Parameters**: N=384, H=4096, rate_num=4, outer_margin=24, `r_max_glob=136`

**Center A**: slope=1.001979, r2=1.000000, cv=0.001498, amp_mean=605.797201, log_bins=14, lin_nbins=4  
**Center B**: slope=1.001979, r2=1.000000, cv=0.001498, amp_mean=605.797201, log_bins=14, lin_nbins=4

**Pair**: Δslope=0.000000, Δcv=0.000000, amp_ratio(B/A)=1.000000  
Status: per‑center OK = {'A': True, 'B': True}, invariance OK = True, amplitude OK = True, **PASS = True**

## Recreating the PASS exactly

- The exact engine and manifest used are in this repo.
- To reproduce the same configuration, simply run `./scripts/run.sh`. A new UTC‑stamped workspace will be created and evaluated with the same acceptance gates.

## Notes

- The v2 changes (common window, heavier averaging, larger grid) suppress lattice discreteness and edge effects, bringing ΔCV → 0 and amp_ratio → 1 while preserving ~1 slope.
- Everything is deterministic; repeat runs with the same manifest will produce identical numbers.
